package se.kth.anderslm.todo;

import java.util.ArrayList;

import android.app.Activity;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListView;

public class ToDoActivity extends Activity {
	
	private EditText toDoInput;
	private ListView toDoListView;
	
	private ArrayList<String> toDoItems;
	private ArrayAdapter<String> adapter;
	
	private static final int ADD_ITEM = 0, REMOVE_ITEM = 1, CANCEL_ITEM = 2;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // Inflate the view from XML
        this.setContentView(R.layout.main);
        
        // Get references to the user interface components
        toDoInput = (EditText) findViewById(R.id.InputText);
        toDoListView = (ListView) findViewById(R.id.ToDoListView);
        
        // Create an ArrayList for the to-do-items
        toDoItems = new ArrayList<String>();
        // Create an ArrayAdapter to bind the ListView to the data
        adapter = new ArrayAdapter<String>(
        		this, android.R.layout.simple_list_item_1, toDoItems);
        toDoListView.setAdapter(adapter);
        
        // Register the ListView for this Activity's ContextMenu
        this.registerForContextMenu(toDoListView);
    }
    
    /**
     * Overriding this Activity's onCreatePtionsMenu method.
     * A ContextMenu for managing To-DoItems (remove)
     */
    public boolean onCreateOptionsMenu(Menu menu) {
    	menu.add(0, ADD_ITEM, Menu.NONE, "Add To-Do-item");
    	menu.add(0, CANCEL_ITEM, Menu.NONE, "Cancel");
    	
    	return true;
    }
    
    /**
     * Overriding the Activity's onOptionsItemSelected method.
     * This is where we define what actions to take when a menu
     * item is selected.
     */
    public boolean onOptionsItemSelected(MenuItem item) {
    	super.onOptionsItemSelected(item);
    	
    	switch(item.getItemId()) {
    	case ADD_ITEM:
    		String text = toDoInput.getText().toString();
    		toDoItems.add(text);
    		adapter.notifyDataSetChanged(); // Update view via the adapter
    		toDoInput.setText("");
    		return true;
    	case CANCEL_ITEM:
    		// Do nothing
    		return true;	
    	}
    	
    	// Return false to allow normal menu processing to proceed, 
    	// true to consume it here
    	return false; 
    }
    
    /**
     * Overriding this Activity's onCreateContextMenu method.
     * A ContextMenu for managing To-DoItems (remove)
     */
    public void onCreateContextMenu(
    		ContextMenu menu, View view,ContextMenu.ContextMenuInfo menuInfo)
    {
    	super.onCreateContextMenu(menu, view, menuInfo);
    	
    	menu.setHeaderTitle("Manage To-Do-items");
    	menu.add(0, REMOVE_ITEM, ContextMenu.NONE, "Remove item");
    	menu.add(0, CANCEL_ITEM, ContextMenu.NONE, "Cancel");
    }
    
    /**
     * Overriding the Activity's onOptionsItemSelected method.
     * This is where we define what actions to take when a context 
     * menu item is selected.
     */
    public boolean onContextItemSelected(MenuItem item) {
    	super.onContextItemSelected(item);
    	
    	switch(item.getItemId()) {
    	case REMOVE_ITEM:
    		AdapterView.AdapterContextMenuInfo menuInfo;
    		menuInfo = (AdapterView.AdapterContextMenuInfo) item.getMenuInfo();
    		int info = menuInfo.position;
    		toDoItems.remove(info);
    		adapter.notifyDataSetChanged(); // Update view via the adapter
    		return true;
    	case CANCEL_ITEM:
    		// Do nothing
    		return true;	
    	}
    	
    	// Return false to allow normal menu processing to proceed, 
    	// true to consume it here
    	return false; 
    }
}